// OpenLibrieException.cs
//
// Copyright (C) 2004  Peter Knowles
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.

using System;

namespace OpenLibrie {
  /// <summary>
  /// Represents errors generated in the OpenLibrie namespace
  /// </summary>
  public class OpenLibrieException : ApplicationException {
    /// <summary>
    /// Initializes a new instance of OpenLibrieException class with no
    /// text message.
    /// </summary>
    public OpenLibrieException() {}
    
    /// <summary>
    /// Initializes a new instance of the OpenLibrieException class with the
    /// specified error message.
    /// </summary>
    public OpenLibrieException(string message) : base(message) {}
  }

  /// <summary>
  /// Thrown when the XML Info Block Cannot Be Parsed
  /// </summary>
  public class XMLInfoParseException : OpenLibrieException {
    /// <summary>
    /// Initializes a new instance of XMLInfoParseExceptionclass with no
    /// text message.
    /// </summary>
    public XMLInfoParseException() {}
    
    /// <summary>
    /// Initializes a new instance of the XMLInfoParseException class with the
    /// specified error message.
    /// </summary>
    public XMLInfoParseException(string message) : base(message) {}
  }
}
